#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;


using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
#endregion

namespace gov.va.med.vbecs.DAL.UnitTests
{

	
	

	[TestFixture]
	public class DAL_VbecsReport : BaseTest 
	{

		private DataTable _dtReport;

		[SetUp]
		protected void SetUp()
		{
			this.BaseSetUp();

			this._dtReport = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ScheduledReport", false);
			if (this._dtReport.Rows.Count == 0)
			{
				this.InsertScheduledReport_Pass();
				this._dtReport = UnitTestUtil.RunSQLGetDataTable("SELECT TOP 1 * FROM ScheduledReport", true);
			}
		}

		[Test]
		public void GetScheduledReports_Pass()
		{
			DataTable dtTest = DAL.VbecsReport.GetScheduledReports(Common.TaskStatus.Completed);

			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");
			
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.ScheduledReportGuid), TABLES.ScheduledReport.ScheduledReportGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.ReportParameters), TABLES.ScheduledReport.ReportParameters);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.ReportPrintDate), TABLES.ScheduledReport.ReportPrintDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.TaskStatusCode), TABLES.ScheduledReport.TaskStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.RowVersion), TABLES.ScheduledReport.RowVersion);
		}

		[Test]
		public void GetScheduledReports_Fail() 
		{
			DataTable dtTest = DAL.VbecsReport.GetScheduledReports(Common.TaskStatus.Unknown);

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void GetScheduledReport_Pass()
		{
			System.Guid srGuid = (System.Guid)this._dtReport.Rows[0][TABLES.ScheduledReport.ScheduledReportGuid];

			DataTable dtTest = DAL.VbecsReport.GetScheduledReport(srGuid);

			Assert.AreEqual(1, dtTest.Rows.Count, "Rows.Count");
			Assert.AreEqual(5, dtTest.Columns.Count, "Columns.Count");

			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.ScheduledReportGuid), TABLES.ScheduledReport.ScheduledReportGuid);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.ReportParameters), TABLES.ScheduledReport.ReportParameters);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.ReportPrintDate), TABLES.ScheduledReport.ReportPrintDate);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.TaskStatusCode), TABLES.ScheduledReport.TaskStatusCode);
			Assert.AreEqual(true, dtTest.Columns.Contains(TABLES.ScheduledReport.RowVersion), TABLES.ScheduledReport.RowVersion);
		}

		[Test]
		public void GetScheduledReport_Fail() 
		{
			DataTable dtTest = DAL.VbecsReport.GetScheduledReport(System.Guid.NewGuid());

			Assert.AreEqual(0, dtTest.Rows.Count, "Rows.Count");
		}

		[Test]
		public void UpdateScheduledReportStatus_Pass()
		{
			this.RefreshData = true;

			System.Guid srGuid = (System.Guid)this._dtReport.Rows[0][TABLES.ScheduledReport.ScheduledReportGuid];
			byte[] srRowVersion = (byte[])this._dtReport.Rows[0][TABLES.ScheduledReport.RowVersion];
			Common.TaskStatus taskStatus = Common.TaskStatus.Completed;

			if (this._dtReport.Rows[0][TABLES.ScheduledReport.TaskStatusCode].ToString() == "C")
			{
				taskStatus = Common.TaskStatus.Expired;
			}

			bool retValue = DAL.VbecsReport.UpdateScheduledReportStatus(srGuid, taskStatus, srRowVersion);

			Assert.AreEqual(true, retValue, "ReturnValue");

			//Double-check the updated value
			DataTable dtTest = DAL.VbecsReport.GetScheduledReport(srGuid);
			Assert.AreEqual(Common.Utility.GetTaskStatusCodeFromEnum(taskStatus).ToString(), dtTest.Rows[0][TABLES.ScheduledReport.TaskStatusCode].ToString(), "Updated Value");

		}

		[Test]
		[ExpectedException(typeof(Common.RowVersionException))]
		public void UpdateScheduledReportStatus_Fail() 
		{
			this.RefreshData = true;

			System.Guid srGuid = (System.Guid)this._dtReport.Rows[0][TABLES.ScheduledReport.ScheduledReportGuid];
			byte[] srRowVersion = new byte[8];
			Common.TaskStatus taskStatus = Common.TaskStatus.Completed;

			if (this._dtReport.Rows[0][TABLES.ScheduledReport.TaskStatusCode].ToString() == "C")
			{
				taskStatus = Common.TaskStatus.Expired;
			}

			DAL.VbecsReport.UpdateScheduledReportStatus(srGuid, taskStatus, srRowVersion);

		}

		[Test]
		public void InsertScheduledReport_Pass()
		{
			System.DateTime printDate = System.DateTime.Now;

			DataSet dsTest = new DataSet();
			DataTable dt = new DataTable();
			dt.Columns.Add(TABLES.BloodUnit.BloodUnitGuid, typeof(System.Guid));
			dt.Columns.Add(TABLES.BloodUnit.RecordStatusCode, typeof(string));

			dt.Rows.Add(dt.NewRow());
			dt.Rows[0][TABLES.BloodUnit.BloodUnitGuid] = System.Guid.NewGuid();
			dt.Rows[0][TABLES.BloodUnit.RecordStatusCode] = System.Guid.NewGuid();
			dsTest.Tables.Add(dt);

			bool retValue = DAL.VbecsReport.InsertScheduledReport(dsTest, printDate);
			Assert.AreEqual(true, retValue, "ReturnValue");
		}

		[Test]
		[Ignore(StandardIgnoreReasons.NoFailureConditions)]
		public void InsertScheduledReport_Fail() 
		{
		}


	}
}
#endif
